package ru.yandex.solomon.core.urlStatus;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.proto.UrlStatusType;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class UrlStatusTypeException extends RuntimeException implements UrlStatusTypeAwareException {

    private final UrlStatusType urlStatusType;

    public UrlStatusTypeException(String message, UrlStatusType urlStatusType) {
        super(message);
        this.urlStatusType = urlStatusType;
    }

    public UrlStatusTypeException(UrlStatusType urlStatusType) {
        super(urlStatusType.name());
        this.urlStatusType = urlStatusType;
    }

    @Override
    public UrlStatusType urlStatusType() {
        return urlStatusType;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        // do not fill stacktrace
        return this;
    }
}
