package ru.yandex.solomon.core.conf;

import org.junit.Test;

import ru.yandex.solomon.core.conf.watch.SolomonConfHolder;

import static org.junit.Assert.assertEquals;

/**
 * @author Nuradil Zhambyl
 */
public class ConfigReadinessCheckerTest {
    @Test
    public void checkReady() {
        SolomonConfHolder confHolder = new SolomonConfHolder();
        confHolder.onConfigurationLoad(SolomonConfWithContext.create(SolomonRawConf.EMPTY));
        boolean readiness = new ConfigReadinessChecker(confHolder).status().ok;
        assertEquals(readiness, true);
    }

    @Test
    public void checkUnready() {
        SolomonConfHolder confHolder = new SolomonConfHolder();
        boolean readiness = new ConfigReadinessChecker(confHolder).status().ok;
        assertEquals(readiness, false);
    }
}
