package ru.yandex.solomon.core.conf;

import java.util.List;

import org.hamcrest.Matchers;
import org.junit.Test;

import ru.yandex.solomon.core.db.model.Cluster;
import ru.yandex.solomon.core.db.model.Project;
import ru.yandex.solomon.core.db.model.Service;
import ru.yandex.solomon.core.db.model.Shard;

import static org.hamcrest.Matchers.hasItem;
import static org.hamcrest.Matchers.not;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class SolomonRawConfTest {

    @Test
    public void addShard() {
        SolomonRawConf empty = new SolomonRawConf(List.of(), List.of(), List.of(), List.of(), List.of());
        assertThat(empty.getProjectIds(), not(Matchers.hasItem("solomon")));

        Project project = Project.newBuilder()
            .setId("solomon")
            .setName("SolomonProject")
            .setAbcService("solomon")
            .setOwner("gordiychuk")
            .build();

        Service service = Service.newBuilder()
            .setId("solomon_stockpile")
            .setName("stockpile")
            .setProjectId("solomon")
            .build();

        Cluster cluster = Cluster.newBuilder()
            .setId("solomon_prod")
            .setName("prod")
            .setProjectId("solomon")
            .build();

        Shard shard = Shard.newBuilder()
            .setId("solomon_prod_stockpile")
            .setNumId(1)
            .setClusterId("solomon_prod")
            .setClusterName("prod")
            .setServiceId("solomon_stockpile")
            .setServiceName("stockpile")
            .setProjectId("solomon")
            .build();

        SolomonRawConf result = empty.addShard(project, shard, cluster, service);
        assertThat(result.getProjectIds(), hasItem("solomon"));
        assertThat(result.getClusters(), hasItem(cluster));
        assertThat(result.getServices(), hasItem(service));
        assertThat(result.getShards(), hasItem(shard));
    }

    @Test
    public void shardIdCanBeNotUniq() {
        var projects = List.of(
                Project.newBuilder()
                        .setId("solomon")
                        .setName("solomon")
                        .setAbcService("solomon")
                        .setOwner("gordiychuk")
                        .build(),
                Project.newBuilder()
                        .setId("solomon_cloud")
                        .setName("solomon cloud")
                        .setAbcService("solomon")
                        .setOwner("gordiychuk")
                        .build());

        var clusters = List.of(
                Cluster.newBuilder()
                        .setId("solomon_prod")
                        .setName("prod")
                        .setProjectId("solomon")
                        .build(),
                Cluster.newBuilder()
                        .setId("solomon_prod")
                        .setName("prod")
                        .setProjectId("solomon_cloud")
                        .build());

        var services = List.of(
                Service.newBuilder()
                        .setId("solomon_stockpile")
                        .setName("stockpile")
                        .setProjectId("solomon")
                        .build(),
                Service.newBuilder()
                        .setId("solomon_stockpile")
                        .setName("stockpile")
                        .setProjectId("solomon_cloud")
                        .build());

        var shards = List.of(
            Shard.newBuilder()
                    .setId("solomon_prod_stockpile")
                    .setNumId(42)
                    .setClusterId("solomon_prod")
                    .setClusterName("prod")
                    .setServiceId("solomon_stockpile")
                    .setServiceName("stockpile")
                    .setProjectId("solomon")
                    .build(),
                Shard.newBuilder()
                        .setId("solomon_prod_stockpile")
                        .setNumId(43)
                        .setClusterId("solomon_prod")
                        .setClusterName("prod")
                        .setServiceId("solomon_stockpile")
                        .setServiceName("stockpile")
                        .setProjectId("solomon_cloud")
                        .build()
        );

        SolomonRawConf conf = new SolomonRawConf(List.of(), projects, clusters, services, shards);

        assertEquals(projects, conf.getProjects());
        assertEquals(clusters, conf.getClusters());
        assertEquals(services, conf.getServices());
        assertEquals(shards, conf.getShards());
    }
}
