package ru.yandex.solomon.core.conf.aggr;

import org.junit.Test;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.labels.LabelsFormat;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class LabelCondTest {

    @Test
    public void matchAny() {
        var cond = create("host=*");
        assertTrue(cond.allMatch(labels("host=alice, metric=test")));
        assertTrue(cond.allMatch(labels("host=bob, metric=test")));
        assertFalse(cond.allMatch(labels("metric=test")));
    }

    @Test
    public void matchAnyWithOpt() {
        var cond = create("DC=*");
        assertTrue(cond.allMatch(labels("host=alice, metric=test"), labels("DC=Man")));
        assertTrue(cond.allMatch(labels("host=alice, metric=test, DC=Man"), labels("")));
        assertTrue(cond.allMatch(labels("host=bob, metric=test"), labels("DC=Sas")));
        assertTrue(cond.allMatch(labels("host=bob, metric=test, DC=Sas"), labels("")));
        assertFalse(cond.allMatch(labels("metric=test")));
    }

    @Test
    public void hostNotRequired() {
        assertFalse(create("DC=*").isHostRequired());
        assertFalse(create("host=*").isHostRequired());
        assertFalse(create("host=*", "DC=*").isHostRequired());
        assertFalse(create("DC=*", "host=*").isHostRequired());
    }

    @Test
    public void hostRequired() {
        assertTrue(create("DC=*", "host=test-*").isHostRequired());
        assertTrue(create("host=*", "host=my-range-*").isHostRequired());
        assertTrue(create("host=my-range-*", "host=*").isHostRequired());
        assertTrue(create("host=exact_value").isHostRequired());
        assertTrue(create("host=!exact_value").isHostRequired());
    }

    private Labels labels(String labels) {
        return LabelsFormat.parse(labels);
    }

    private LabelCond create(String... conditions) {
        return LabelCond.parse(conditions);
    }
}
