package ru.yandex.solomon.core.conf.aggr;

import java.util.Set;

import org.junit.Test;

import ru.yandex.solomon.labels.shard.ShardKey;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

/**
 * @author Vladimir Gordiychuk
 */
public class TargetParsedTest {

    @Test
    public void parseConst() {
        var result = parse("host=cluster");
        assertEquals("host", result.getName());
        assertEquals(Set.of(), result.getSubstitutionLabelNames());
        assertFalse(result.isHostRequired());
    }

    @Test
    public void parseSubstitution() {
        var result = parse("host={{DC}}");
        assertEquals("host", result.getName());
        assertEquals(Set.of("DC"), result.getSubstitutionLabelNames());
        assertFalse(result.isHostRequired());
    }

    @Test
    public void parseMultipleSubstitution() {
        var result = parse("host={{host}}-{{DC}}");
        assertEquals("host", result.getName());
        assertEquals(Set.of("host", "DC"), result.getSubstitutionLabelNames());
        assertTrue(result.isHostRequired());
    }

    @Test
    public void notHostAtAll() {
        var result = parse("sink=total");
        assertEquals("sink", result.getName());
        assertEquals(Set.of(), result.getSubstitutionLabelNames());
        assertFalse(result.isHostRequired());
    }

    private TargetParsed parse(String target) {
        var shard = new ShardKey("project", "cluster", "service");
        return TargetParsed.parseReplaceSpecials(target, shard, Set.of());
    }
}
