package ru.yandex.solomon.core.db.dao;

import java.util.List;

import org.junit.Test;

import ru.yandex.devtools.test.annotations.YaExternal;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
@YaExternal
public abstract class AbstractEntityFlagsDaoTest {

    public abstract EntityFlagsDao getDao();

    @Test
    public void findEmpty() {
        var result = getDao().findAll().join();
        assertEquals(List.of(), result);
    }

    @Test
    public void upsert() {
        var dao = getDao();

        var recordOne = new EntityFlagsDao.Record("myFlag", "myProject", "myId", true);
        dao.upsert(recordOne).join();
        assertEquals(List.of(recordOne), dao.findAll().join());

        var recordTwo = new EntityFlagsDao.Record("myFlag", "myProject2", "myId", false);
        dao.upsert(recordTwo).join();
        assertEquals(List.of(recordOne, recordTwo), dao.findAll().join());
    }

    @Test
    public void delete() {
        var dao = getDao();

        var recordOne = new EntityFlagsDao.Record("myFlag", "myProject", "myId",true);
        var recordTwo = new EntityFlagsDao.Record("myFlag", "myProject2","myId", false);
        for (var record : List.of(recordOne, recordTwo)) {
            dao.upsert(record).join();
        }
        assertEquals(List.of(recordOne, recordTwo), dao.findAll().join());

        dao.deleteOne("myFlag", "myProject", "myId").join();
        assertEquals(List.of(recordTwo), dao.findAll().join());
    }
}
