package ru.yandex.solomon.core.db.dao;

import java.util.List;

import org.junit.Test;

import ru.yandex.devtools.test.annotations.YaExternal;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
@YaExternal
public abstract class AbstractProjectFlagsDaoTest {

    public abstract ProjectFlagsDao getDao();

    @Test
    public void findEmpty() {
        var result = getDao().findAll().join();
        assertEquals(List.of(), result);
    }

    @Test
    public void upsert() {
        var dao = getDao();

        var recordOne = new ProjectFlagsDao.Record("myFlag", "myProject", true);
        dao.upsert(recordOne).join();
        assertEquals(List.of(recordOne), dao.findAll().join());

        var recordTwo = new ProjectFlagsDao.Record("myFlag", "myProject2", false);
        dao.upsert(recordTwo).join();
        assertEquals(List.of(recordOne, recordTwo), dao.findAll().join());
    }

    @Test
    public void delete() {
        var dao = getDao();

        var recordOne = new ProjectFlagsDao.Record("myFlag", "myProject", true);
        var recordTwo = new ProjectFlagsDao.Record("myFlag", "myProject2", false);
        for (var record : List.of(recordOne, recordTwo)) {
            dao.upsert(record).join();
        }
        assertEquals(List.of(recordOne, recordTwo), dao.findAll().join());

        dao.deleteOne("myFlag", "myProject").join();
        assertEquals(List.of(recordTwo), dao.findAll().join());
    }
}
