package ru.yandex.solomon.core.db.dao;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import ru.yandex.solomon.core.db.model.AuditableBuilder;

import static junit.framework.TestCase.fail;


/**
 * @author snoop
 */
public class DaoTestFixture {

    private DaoTestFixture() {
    }

    public static <Key, T> Map<Key, T> byId(List<T> objectList, Function<T, Key> keySupply) {
        return objectList.stream().collect(Collectors.toMap(keySupply::apply, Function.identity()));
    }

    public static <T> void equalsByString(T first, T second) {
        if (!EqualsBuilder.reflectionEquals(first, second)) {
            String firstAsText = ToStringBuilder.reflectionToString(first, ToStringStyle.NO_CLASS_NAME_STYLE);
            String secondAsText = ToStringBuilder.reflectionToString(second, ToStringStyle.NO_CLASS_NAME_STYLE);
            fail("Found difference in \n" + firstAsText + "'\n" + secondAsText);
        }
    }

    public static <T extends AuditableBuilder<T>> T increment(T builder) {
        return builder.setVersion(builder.getVersion() + 1);
    }

    public static <T extends AuditableBuilder<T>> T decrement(T builder) {
        return builder.setVersion(builder.getVersion() - 1);
    }
}
