package ru.yandex.solomon.core.db.dao;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameter;
import org.junit.runners.Parameterized.Parameters;

import ru.yandex.solomon.selfmon.mon.DaoMetricsProxy;


/**
 * @author Sergey Polovko
 */
@RunWith(Parameterized.class)
public class UniqueNamesTest {

    @Parameter
    public Class<?> daoInterface;

    @Parameters(name = "{0}")
    public static Class[] data() {
        return new Class[] {
            ClustersDao.class,
            DashboardsDao.class,
            GraphsDao.class,
            ProjectMenuDao.class,
            ProjectsDao.class,
            ServicesDao.class,
            ShardsDao.class,
            UserSettingsDao.class,
            ViewHistoryDao.class,
            AgentDao.class,
            QuotasDao.class,
        };
    }

    @Test
    public void methodNames() {
        Set<String> uniqueNames = new HashSet<>();
        for (Method method : daoInterface.getMethods()) {
            String name = DaoMetricsProxy.getMethodName(method);
            Assert.assertTrue("method name " + name + " is not unique", uniqueNames.add(name));
        }
    }
}
