package ru.yandex.solomon.core.db.dao.memory;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.After;
import org.junit.Before;

import ru.yandex.solomon.core.db.dao.AbstractQuotasDaoTest;
import ru.yandex.solomon.core.db.dao.QuotasDao;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class InMemoryQuotasDaoTest extends AbstractQuotasDaoTest {
    private final QuotasDao dao;

    public InMemoryQuotasDaoTest() {
        this.dao = new InMemoryQuotasDao();
    }

    @Before
    public void setUp() {
        dao.createSchemaForTests();
        super.setUp();
    }

    @After
    public void tearDown() {
        dao.dropSchemaForTests();
    }

    @Override
    protected QuotasDao getQuotasDao() {
        return dao;
    }
}
