package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractAgentDaoTest;
import ru.yandex.solomon.core.db.dao.AgentDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;

/**
 * @author Max Sherbakov
 */
public class YdbAgentDaoTest extends AbstractAgentDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbAgentDao agentDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        agentDao = new YdbAgentDao(ydb.getTableClient(), ydb.resolvePath("Agents"), createObjectMapper());
        join(agentDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(agentDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected AgentDao getAgentDao() { return agentDao; }
}
