package ru.yandex.solomon.core.db.dao.ydb;

import java.util.concurrent.ForkJoinPool;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractClustersDaoTest;
import ru.yandex.solomon.core.db.dao.ClustersDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;


/**
 * @author Sergey Polovko
 */
public class YdbClustersDaoTest extends AbstractClustersDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbClustersDao clustersDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        clustersDao = new YdbClustersDao(ydb.getTableClient(), ydb.resolvePath("Clusters"), createObjectMapper(), ForkJoinPool.commonPool());
        join(clustersDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(clustersDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected ClustersDao getClustersDao() {
        return clustersDao;
    }
}
