package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractDashboardsDaoTest;
import ru.yandex.solomon.core.db.dao.DashboardsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;


/**
 * @author Sergey Polovko
 */
public class YdbDashboardsDaoTest extends AbstractDashboardsDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbDashboardsDao dashboardsDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        dashboardsDao = new YdbDashboardsDao(ydb.getTableClient(), ydb.resolvePath("Dashboards"), createObjectMapper());
        join(dashboardsDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(dashboardsDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public DashboardsDao getDashboardsDao() {
        return dashboardsDao;
    }
}
