package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractEntityFlagsDaoTest;
import ru.yandex.solomon.core.db.dao.EntityFlagsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbEntityFlagsDaoTest extends AbstractEntityFlagsDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbEntityFlagsDao dao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        dao = new YdbEntityFlagsDao(ydb.getTableClient(), ydb.resolvePath("EntityFlags"));
        join(dao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(dao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public EntityFlagsDao getDao() {
        return dao;
    }
}
