package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractFolderMenuDaoTest;
import ru.yandex.solomon.core.db.dao.FolderMenuDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;


/**
 * @author Sergey Polovko
 */
public class YdbFolderMenuDaoTest extends AbstractFolderMenuDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbFolderMenuDao folderMenuDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        folderMenuDao = new YdbFolderMenuDao(ydb.getTableClient(), ydb.resolvePath("FolderMenu"), createObjectMapper());
        join(folderMenuDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(folderMenuDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected FolderMenuDao getFolderMenuDao() {
        return folderMenuDao;
    }
}
