package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractGraphsDaoTest;
import ru.yandex.solomon.core.db.dao.GraphsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;


/**
 * @author Sergey Polovko
 */
public class YdbGraphsDaoTest extends AbstractGraphsDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbGraphsDao graphsDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        graphsDao = new YdbGraphsDao(ydb.getTableClient(), ydb.resolvePath("Graphs"), createObjectMapper());
        join(graphsDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(graphsDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public GraphsDao getGraphsDao() {
        return graphsDao;
    }
}
