package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractProjectFlagsDaoTest;
import ru.yandex.solomon.core.db.dao.ProjectFlagsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Vladimir Gordiychuk
 */
public class YdbProjectFlagsDaoTest extends AbstractProjectFlagsDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbProjectFlagsDao dao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        dao = new YdbProjectFlagsDao(ydb.getTableClient(), ydb.resolvePath("ProjectFlags"));
        join(dao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(dao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public ProjectFlagsDao getDao() {
        return dao;
    }
}
