package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractProjectMenuDaoTest;
import ru.yandex.solomon.core.db.dao.ProjectMenuDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;


/**
 * @author Sergey Polovko
 */
public class YdbProjectMenuDaoTest extends AbstractProjectMenuDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbProjectMenuDao projectMenuDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        projectMenuDao = new YdbProjectMenuDao(ydb.getTableClient(), ydb.resolvePath("ProjectMenus"), createObjectMapper());
        join(projectMenuDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(projectMenuDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected ProjectMenuDao getProjectMenuDao() {
        return projectMenuDao;
    }
}
