package ru.yandex.solomon.core.db.dao.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractProjectSettingsDaoTest;
import ru.yandex.solomon.core.db.dao.ProjectSettingsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class YdbProjectSettingsDaoTest extends AbstractProjectSettingsDaoTest {
    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbProjectSettingsDao projectSettingsDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        projectSettingsDao = new YdbProjectSettingsDao(ydb.getTableClient(), ydb.resolvePath("ProjectSettings"), createObjectMapper());
        join(projectSettingsDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(projectSettingsDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public ProjectSettingsDao getProjectSettingsDao() {
        return projectSettingsDao;
    }
}
