package ru.yandex.solomon.core.db.dao.ydb;

import java.util.concurrent.ForkJoinPool;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractProjectsDaoTest;
import ru.yandex.solomon.core.db.dao.ProjectsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;


/**
 * @author Sergey Polovko
 */
public class YdbProjectsDaoTest extends AbstractProjectsDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbProjectsDao projectsDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        projectsDao = new YdbProjectsDao(ydb.getTableClient(), ydb.resolvePath("Projects"), new ObjectMapper(), ForkJoinPool.commonPool());
        join(projectsDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(projectsDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public ProjectsDao getProjectsDao() {
        return projectsDao;
    }
}
