package ru.yandex.solomon.core.db.dao.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractQuotasDaoTest;
import ru.yandex.solomon.core.db.dao.QuotasDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class YdbQuotasDaoTest extends AbstractQuotasDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbQuotasDao quotasDao;

    @Before
    public void setUp() {
        super.setUp();
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        quotasDao = new YdbQuotasDao(ydb.getTableClient(), ydb.resolvePath("Quotas"));
        join(quotasDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(quotasDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected QuotasDao getQuotasDao() { return quotasDao; }
}
