package ru.yandex.solomon.core.db.dao.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractServiceProvidersDaoTest;
import ru.yandex.solomon.core.db.dao.ServiceProvidersDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class YdbServiceProvidersDaoTest extends AbstractServiceProvidersDaoTest {
    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbServiceProvidersDao serviceProvidersDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        serviceProvidersDao = new YdbServiceProvidersDao(ydb.getTableClient(), ydb.resolvePath("ServiceProviders"), createObjectMapper());
        join(serviceProvidersDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(serviceProvidersDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected ServiceProvidersDao getDao() {
        return serviceProvidersDao;
    }
}
