package ru.yandex.solomon.core.db.dao.ydb;

import java.util.concurrent.ForkJoinPool;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractServicesDaoTest;
import ru.yandex.solomon.core.db.dao.ServicesDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;


/**
 * @author Sergey Polovko
 */
public class YdbServicesDaoTest extends AbstractServicesDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbServicesDao servicesDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        servicesDao = new YdbServicesDao(ydb.getTableClient(), ydb.resolvePath("Services"), createObjectMapper(), ForkJoinPool.commonPool());
        join(servicesDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(servicesDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected ServicesDao getServicesDao() {
        return servicesDao;
    }
}
