package ru.yandex.solomon.core.db.dao.ydb;

import java.util.concurrent.ForkJoinPool;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractShardsDaoTest;
import ru.yandex.solomon.core.db.dao.ShardsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;


/**
 * @author Sergey Polovko
 */
public class YdbShardsDaoTest extends AbstractShardsDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbShardsDao shardsDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        shardsDao = new YdbShardsDao(ydb.getTableClient(), ydb.resolvePath("Shards"), new ObjectMapper(), ForkJoinPool.commonPool());
        join(shardsDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(shardsDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected ShardsDao getShardsDao() {
        return shardsDao;
    }
}
