package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractUserSettingsDaoTest;
import ru.yandex.solomon.core.db.dao.UserSettingsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;


/**
 * @author Sergey Polovko
 */
public class YdbUserSettingsDaoTest extends AbstractUserSettingsDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbUserSettingsDao userSettingsDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        userSettingsDao = new YdbUserSettingsDao(ydb.getTableClient(), ydb.resolvePath("UserSettings"), createObjectMapper());
        join(userSettingsDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(userSettingsDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public UserSettingsDao getUserSettingsDao() {
        return userSettingsDao;
    }
}
