package ru.yandex.solomon.core.db.dao.ydb;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.core.db.dao.AbstractViewHistoryDaoTest;
import ru.yandex.solomon.core.db.dao.ViewHistoryDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;


/**
 * @author Sergey Polovko
 */
public class YdbViewHistoryDaoTest extends AbstractViewHistoryDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbViewHistoryDao viewHistoryDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        viewHistoryDao = new YdbViewHistoryDao(ydb.getTableClient(), ydb.resolvePath("ViewHistories"));
        join(viewHistoryDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(viewHistoryDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    protected ViewHistoryDao getViewHistoryDao() {
        return viewHistoryDao;
    }
}
