package ru.yandex.solomon.core.db.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Test;

import ru.yandex.solomon.core.db.model.ServiceMetricConf.AggrRule;

import static org.junit.Assert.assertEquals;

/**
 * @author Vladimir Gordiychuk
 */
public class ServiceProviderShardSettingsTest {

    @Test
    public void fromJsonZero() {
        var result = fromJson("""
                {
                    "metricConf": {
                        "aggrRules": [],
                        "rawDataMemOnly": false
                    },
                    "grid": 0,
                    "metricsTtlDays": 0
                }
                """);

        assertEquals(ServiceProviderShardSettings.EMPTY, result);
    }

    @Test
    public void fromJsonAggr() {
        var result = fromJson("""
                {
                    "metricConf": {
                        "aggrRules": [
                            {
                                "cond": [
                                    "host=*"
                                ],
                                "target": [
                                    "host=-"
                                ]
                            }
                        ],
                        "rawDataMemOnly": true
                    },
                    "grid": 15,
                    "metricsTtlDays": 30
                }
                """);

        var aggr = ServiceMetricConf.of(new AggrRule[]{
                AggrRule.of("host=*", "host=-", null)
        }, true);
        var expected = new ServiceProviderShardSettings(aggr, 30, 15, 0);
        assertEquals(expected, result);
    }

    @Test
    public void fromJsonInterval() {
        var result = fromJson("""
                {
                    "metricConf": {
                        "aggrRules": [],
                        "rawDataMemOnly": false
                    },
                    "grid": 0,
                    "interval": 30
                }
                """);

        var expected = new ServiceProviderShardSettings(ServiceMetricConf.empty(), 0, 0, 30);
        assertEquals(expected, result);
    }


    private ServiceProviderShardSettings fromJson(String json) {
        try {
            var mapper = new ObjectMapper();
            return mapper.readValue(json, ServiceProviderShardSettings.class);
        } catch (java.io.IOException e) {
            throw new RuntimeException(e);
        }
    }

}
