package ru.yandex.solomon.core.db.model;

import java.io.IOException;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Test;

import static org.junit.Assert.assertEquals;

/**
 * @author Alexey Trushkin
 */
public class ShardSettingsTest {

    public static final ObjectMapper objectMapper = new ObjectMapper();

    @Test
    public void fromJsonWithFailedEnum() throws IOException {
        objectMapper.enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE);
        var settings = getShardSettings();
        String json = objectMapper.writeValueAsString(settings);
        String newJson = json.replaceAll("UNSPECIFIED", "NOT_DEFINED_ENUM_VALUE");
        ShardSettings shardSettings = objectMapper.readValue(newJson, ShardSettings.class);
        assertEquals(settings.getGrid(), shardSettings.getGrid());
        assertEquals(settings.getMetricsTtl(), shardSettings.getMetricsTtl());
        assertEquals(settings.getPullSettings(), shardSettings.getPullSettings());
        assertEquals(settings.getAggregationSettings(), shardSettings.getAggregationSettings());
        assertEquals(ShardSettings.Type.UNSPECIFIED, shardSettings.getType());
    }

    @Test
    public void fromJson() throws IOException {
        var settings = getShardSettings();
        String json = objectMapper.writeValueAsString(settings);
        ShardSettings shardSettings = objectMapper.readValue(json, ShardSettings.class);
        assertEquals(settings, shardSettings);
    }

    @Test
    public void withOldInterval() throws IOException {
        var json = "{\"type\":\"UNSPECIFIED\"," +
                "\"pullSettings\":{\"port\":10,\"interval\":20,\"path\":\"\",\"addTsArgs\":false,\"tvmDestinationId\":\"\",\"hostLabelPolicy\":\"NO_HOSTNAME\"}," +
                "\"grid\":15,\"metricsTtl\":10,\"retentionPolicy\":\"POLICY_5_MIN_AFTER_7_DAYS\"," +
                "\"aggregationSettings\":{\"enabled\":false,\"aggrRules\":[],\"memOnly\":false}}";
        ShardSettings shardSettings = objectMapper.readValue(json, ShardSettings.class);
        assertEquals(0, shardSettings.getInterval());
    }

    private ShardSettings getShardSettings() {
        return ShardSettings.of(ShardSettings.Type.UNSPECIFIED,
                null,
                15,
                10,
                DecimPolicy.DEFAULT,
                ShardSettings.AggregationSettings.EMPTY,
                11);
    }

}
