package ru.yandex.solomon.core.label;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

import com.google.common.collect.Collections2;
import org.junit.Assert;
import org.junit.Test;

/**
 * @author Stepan Koltsov
 */
public class FixedOrderStringSorterTest {

    @Test
    public void testSortLabelsWithPartialOrder() {
        List<String> order = Arrays.asList("foo", "bar", "baz");

        FixedOrderStringSorter sorter = new FixedOrderStringSorter(order);
        Comparator<String> comparator = sorter.asPartialNameComparator();

        List<String> expected = Arrays.asList("foo", "bar", "aa", "bb", "cc");

        for (List<String> perm : Collections2.permutations(expected)) {

            List<String> sortedPerm =
                perm.stream()
                    .sorted(comparator)
                    .collect(Collectors.toList());

            Assert.assertEquals(expected, sortedPerm);
        }
    }
}
