package ru.yandex.solomon.core.urlStatus;

import java.io.IOException;

import org.junit.Test;

import ru.yandex.solomon.proto.UrlStatusType;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;

/**
 * @author Vladimir Gordiychuk
 */
public class UrlStatusTypesTest {

    @Test
    public void unknownIOException() {
        UrlStatusType result = UrlStatusTypes.classifyError(new IOException());
        assertThat(result, equalTo(UrlStatusType.UNKNOWN_ERROR));
    }

    @Test
    public void connectionFailureFromIOException() {
        UrlStatusType result = UrlStatusTypes.classifyError(new IOException("Connection reset by peer bla bla bla"));
        assertThat(result, equalTo(UrlStatusType.CONNECT_FAILURE));
    }
}
