package ru.yandex.solomon.core.validators;

import org.apache.commons.lang3.StringUtils;
import org.junit.Test;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
public class IdValidatorTest {

    @Test(expected = BadRequestException.class)
    public void idWithForbiddenSymbolsNotValid() {
        IdValidator.ensureValid("<span>", "");
    }

    @Test(expected = BadRequestException.class)
    public void tooLongIdNotValid() {
        IdValidator.ensureValid(StringUtils.repeat('a', 56), "");
    }

    @Test(expected = BadRequestException.class)
    public void tooLongShardIdNotValid() {
        IdValidator.ensureShardIdValid(StringUtils.repeat('a', 181), "");
    }

    @Test
    public void shardIdIsValid() {
        IdValidator.ensureShardIdValid(StringUtils.repeat('a', 180), "");
    }

    @Test(expected = BadRequestException.class)
    public void tooLongProjectIdNotValid() {
        IdValidator.ensureProjectIdValid(StringUtils.repeat('a', 81));
    }

    @Test
    public void projectIdIsValid() {
        IdValidator.ensureProjectIdValid(StringUtils.repeat('a', 80));
    }

    @Test(expected = BadRequestException.class)
    public void slashDisabled() {
        IdValidator.ensureValid("0c7193fb-c914-4980-a62a-5199e136b1bb/global/global/1", "");
    }

    @Test
    public void dotsAllowed() {
        IdValidator.ensureValid("yc.billing.service-cloud", "");
    }
}
