package ru.yandex.solomon.conf.db3;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.conf.db3.ydb.CloudFavoriteRecord;
import ru.yandex.solomon.core.db.SchemaAwareDao;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface CloudFavoritesDao extends SchemaAwareDao {
    CompletableFuture<List<CloudFavoriteRecord>> list(String login, EntityType entityType);

    CompletableFuture<List<CloudFavoriteRecord>> listAll(String login);

    CompletableFuture<Boolean> create(CloudFavoriteRecord record);

    CompletableFuture<Boolean> delete(CloudFavoriteRecord record);

    CompletableFuture<Boolean> exists(CloudFavoriteRecord record);
}
