package ru.yandex.solomon.conf.db3;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class CloudServiceDashboardRecord {
    private final String service;
    private final String id;
    private final String name;
    private final String description;
    private final String data;
    private final long createdAt;
    private final long updatedAt;
    private final String createdBy;
    private final String updatedBy;
    private final int version;

    private CloudServiceDashboardRecord(Builder builder) {
        service = builder.service;
        id = builder.id;
        name = builder.name;
        description = builder.description;
        data = builder.data;
        createdAt = builder.createdAt;
        updatedAt = builder.updatedAt;
        createdBy = builder.createdBy;
        updatedBy = builder.updatedBy;
        version = builder.version;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder();
        builder.service = service;
        builder.id = id;
        builder.name = name;
        builder.description = description;
        builder.data = data;
        builder.createdAt = createdAt;
        builder.updatedAt = updatedAt;
        builder.createdBy = createdBy;
        builder.updatedBy = updatedBy;
        builder.version = version;
        return builder;
    }

    public String getService() {
        return service;
    }

    public String getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public String getData() {
        return data;
    }

    public long getCreatedAt() {
        return createdAt;
    }

    public long getUpdatedAt() {
        return updatedAt;
    }

    public String getCreatedBy() {
        return createdBy;
    }

    public String getUpdatedBy() {
        return updatedBy;
    }

    public int getVersion() {
        return version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CloudServiceDashboardRecord that = (CloudServiceDashboardRecord) o;
        return createdAt == that.createdAt &&
                updatedAt == that.updatedAt &&
                version == that.version &&
                service.equals(that.service) &&
                id.equals(that.id) &&
                name.equals(that.name) &&
                description.equals(that.description) &&
                data.equals(that.data) &&
                createdBy.equals(that.createdBy) &&
                updatedBy.equals(that.updatedBy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(service, id, name, description, data, createdAt, updatedAt, createdBy, updatedBy, version);
    }

    @Override
    public String toString() {
        return "CloudServiceDashboard{" +
                "service='" + service + '\'' +
                ", id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", data='" + data + '\'' +
                ", createdAt=" + createdAt +
                ", updatedAt=" + updatedAt +
                ", createdBy='" + createdBy + '\'' +
                ", updatedBy='" + updatedBy + '\'' +
                ", version=" + version +
                '}';
    }

    public static final class Builder {
        private String service;
        private String id;
        private String name;
        private String description;
        private String data;
        private long createdAt;
        private long updatedAt;
        private String createdBy;
        private String updatedBy;
        private int version;

        private Builder() {
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setData(String data) {
            this.data = data;
            return this;
        }

        public Builder setCreatedAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setUpdatedAt(long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public Builder setVersion(int version) {
            this.version = version;
            return this;
        }

        public CloudServiceDashboardRecord build() {
            return new CloudServiceDashboardRecord(this);
        }
    }
}
