package ru.yandex.solomon.conf.db3;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface CloudServiceDashboardsDao extends SchemaAwareDao {
    CompletableFuture<Boolean> insert(CloudServiceDashboardRecord config);

    CompletableFuture<TokenBasePage<CloudServiceDashboardRecord>> list(
            Set<String> services,
            String filterByName,
            int pageSize,
            String pageToken);

    CompletableFuture<TokenBasePage<CloudServiceDashboardRecord>> listAll(
            String filterByName,
            int pageSize,
            String pageToken);

    CompletableFuture<Optional<CloudServiceDashboardRecord>> read(String dashboardId);

    CompletableFuture<Optional<CloudServiceDashboardRecord>> update(CloudServiceDashboardRecord config);

    CompletableFuture<Void> upsert(CloudServiceDashboardRecord config);

    CompletableFuture<Boolean> delete(String dashboardId);

    CompletableFuture<Boolean> exists(String dashboardId);

    CompletableFuture<Void> deleteByService(String service);
}
