package ru.yandex.solomon.conf.db3;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.conf.db3.ydb.Entity;
import ru.yandex.solomon.core.db.SchemaAwareDao;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface EntitiesDao extends SchemaAwareDao {

    CompletableFuture<Boolean> insert(Entity config);

    @Deprecated
    CompletableFuture<TokenBasePage<Entity>> list(
        String parentId,
        String filterByName,
        int pageSize,
        String pageToken);

    CompletableFuture<TokenBasePage<Entity>> listByLocalId(
            String parentId,
            String filterByLocalId,
            int pageSize,
            String pageToken);

    @Deprecated
    CompletableFuture<TokenBasePage<Entity>> listAll(
        String filterByName,
        int pageSize,
        String pageToken);

    @Deprecated
    CompletableFuture<Optional<Entity>> read(String parentId, String entityId);

    CompletableFuture<Optional<Entity>> readById(String entityId);

    CompletableFuture<List<Entity>> readAll();

    CompletableFuture<Optional<Entity>> update(Entity config);

    CompletableFuture<Void> upsert(Entity config);

    CompletableFuture<Boolean> delete(String parentId, String entityId);

    CompletableFuture<Boolean> deleteWithVersion(String parentId, String entityId, int version);

    CompletableFuture<Boolean> exists(String parentId, String entityId);

    CompletableFuture<Void> deleteByParentId(String parentId);
}
