package ru.yandex.solomon.conf.db3;

import java.util.List;
import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.conf.db3.ydb.FavoriteRecord;
import ru.yandex.solomon.core.db.SchemaAwareDao;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public interface MonitoringFavoritesDao extends SchemaAwareDao {
    CompletableFuture<List<FavoriteRecord>> list(String login, EntityType entityType);

    CompletableFuture<List<FavoriteRecord>> listAll(String login);

    CompletableFuture<Boolean> create(FavoriteRecord record);

    CompletableFuture<Boolean> delete(FavoriteRecord record);

    CompletableFuture<Boolean> exists(FavoriteRecord record);
}
