package ru.yandex.solomon.conf.db3.memory;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

import ru.yandex.solomon.conf.db3.MonitoringDashboardsDao;
import ru.yandex.solomon.conf.db3.ydb.Entity;
import ru.yandex.solomon.ydb.page.TokenBasePage;

/**
 * @author Alexey Trushkin
 */
public class InMemoryMonitoringDashboardsDao implements MonitoringDashboardsDao {
    private final InMemoryEntitiesDao entitiesDao;

    public InMemoryMonitoringDashboardsDao() {
        this.entitiesDao = new InMemoryEntitiesDao();
    }

    @Override
    public CompletableFuture<Boolean> insert(Entity config) {
        return entitiesDao.insert(config);
    }

    @Override
    public CompletableFuture<Optional<Entity>> read(String parentId, String entityId) {
        return entitiesDao.read(parentId, entityId);
    }

    @Override
    public CompletableFuture<Optional<Entity>> readById(String entityId) {
        return entitiesDao.readById(entityId);
    }

    @Override
    public CompletableFuture<List<Entity>> readAll() {
        return entitiesDao.readAll();
    }

    @Override
    public CompletableFuture<TokenBasePage<Entity>> list(
            String parentId,
            String filterByName,
            int pageSize,
            String pageToken) {
        return entitiesDao.list(parentId, filterByName, pageSize, pageToken);
    }

    @Override
    public CompletableFuture<TokenBasePage<Entity>> listByLocalId(
            String parentId,
            String filterByLocalId,
            int pageSize,
            String pageToken) {
        return entitiesDao.listByLocalId(parentId, filterByLocalId, pageSize, pageToken);
    }

    @Override
    public CompletableFuture<TokenBasePage<Entity>> listAll(
            String filterByName,
            int pageSize,
            String pageToken) {
        return entitiesDao.listAll(filterByName, pageSize, pageToken);
    }

    @Override
    public CompletableFuture<Optional<Entity>> update(Entity config) {
        return entitiesDao.update(config);
    }

    @Override
    public CompletableFuture<Void> upsert(Entity config) {
        return entitiesDao.upsert(config);
    }

    @Override
    public CompletableFuture<Boolean> delete(String parentId, String entityId) {
        return entitiesDao.delete(parentId, entityId);
    }

    @Override
    public CompletableFuture<Boolean> deleteWithVersion(String parentId, String entityId, int version) {
        return entitiesDao.deleteWithVersion(parentId, entityId, version);
    }

    @Override
    public CompletableFuture<Boolean> exists(String parentId, String entityId) {
        return entitiesDao.exists(parentId, entityId);
    }

    @Override
    public CompletableFuture<Void> deleteByParentId(String parentId) {
        return entitiesDao.deleteByParentId(parentId);
    }

    @Override
    public CompletableFuture<Void> createSchemaForTests() {
        return entitiesDao.createSchemaForTests();
    }

    @Override
    public CompletableFuture<Void> dropSchemaForTests() {
        return entitiesDao.dropSchemaForTests();
    }
}
