package ru.yandex.solomon.conf.db3.ydb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.Test;

import ru.yandex.solomon.conf.db3.EntityType;
import ru.yandex.solomon.conf.db3.MonitoringFavoritesDao;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assume.assumeTrue;
import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public abstract class MonitoringFavoritesDaoTest {
    protected abstract MonitoringFavoritesDao getDao();

    @Test
    public void insert() {
        assertTrue(insertSync("user", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard"));
    }

    @Test
    public void list() {
        Set<FavoriteRecord> expected = new HashSet<>();
        for (int i = 0; i < 20; ++i) {
            assumeTrue(insertSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_" + i));
            expected.add(new FavoriteRecord("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_" + i));
        }
        for (int i = 0; i < 20; ++i) {
            assumeTrue(insertSync("user1", EntityType.ENTITY_TYPE_PROJECT, "project_" + i));
        }
        for (int i = 0; i < 20; ++i) {
            assumeTrue(insertSync("user2", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_" + i));
        }
        for (int i = 0; i < 20; ++i) {
            assumeTrue(insertSync("user2", EntityType.ENTITY_TYPE_PROJECT, "project_" + i));
        }
        Set<FavoriteRecord> actual = new HashSet<>(listSync("user1", EntityType.ENTITY_TYPE_DASHBOARD));
        assertEquals(expected, actual);
    }

    @Test
    public void exists() {
        assumeTrue(insertSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_1"));
        assumeTrue(insertSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_2"));
        assumeTrue(insertSync("user1", EntityType.ENTITY_TYPE_PROJECT, "project_1"));
        assumeTrue(insertSync("user2", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_1"));
        assumeTrue(insertSync("user2", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_3"));
        assumeTrue(insertSync("user2", EntityType.ENTITY_TYPE_PROJECT, "project_1"));

        assertTrue(existsSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_1"));
        assertTrue(existsSync("user1", EntityType.ENTITY_TYPE_PROJECT, "project_1"));
        assertFalse(existsSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_3"));
        assertFalse(existsSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_4"));
    }

    @Test
    public void delete() {
        assumeTrue(insertSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_1"));
        assumeTrue(insertSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_2"));
        assumeTrue(insertSync("user1", EntityType.ENTITY_TYPE_PROJECT, "project_1"));
        assumeTrue(insertSync("user2", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_1"));
        assumeTrue(insertSync("user2", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_3"));

        assertTrue(deleteSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_1"));
        assertFalse(existsSync("user1", EntityType.ENTITY_TYPE_DASHBOARD, "dashboard_1"));
    }

    private boolean insertSync(String login, EntityType type, String id) {
        return join(getDao().create(new FavoriteRecord(login, type, id)));
    }

    private boolean existsSync(String login, EntityType type, String id) {
        return join(getDao().exists(new FavoriteRecord(login, type, id)));
    }

    private boolean deleteSync(String login, EntityType type, String id) {
        return join(getDao().delete(new FavoriteRecord(login, type, id)));
    }

    private List<FavoriteRecord> listSync(String login, EntityType type) {
        return join(getDao().list(login, type));
    }
}
