package ru.yandex.solomon.conf.db3.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.conf.db3.AbstractCloudServiceDashboardsDaoTest;
import ru.yandex.solomon.conf.db3.CloudServiceDashboardsDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class YdbCloudServiceDashboardsDaoTest extends AbstractCloudServiceDashboardsDaoTest {
    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private CloudServiceDashboardsDao dao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        dao = new YdbCloudServiceDashboardsDao(ydb.getTableClient(), ydb.resolvePath("CloudServiceDashboards"));
        join(dao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(dao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public CloudServiceDashboardsDao getDao() {
        return dao;
    }
}
