package ru.yandex.solomon.conf.db3.ydb;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.TestName;

import ru.yandex.solomon.conf.db3.AbstractQuickLinksDaoTest;
import ru.yandex.solomon.conf.db3.QuickLinksDao;
import ru.yandex.solomon.kikimr.LocalKikimr;
import ru.yandex.solomon.kikimr.YdbHelper;

import static ru.yandex.misc.concurrent.CompletableFutures.join;
import static ru.yandex.solomon.core.db.dao.ConfigDaoContext.createObjectMapper;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class YdbQuickLinksDaoTest extends AbstractQuickLinksDaoTest {

    @ClassRule
    public static LocalKikimr localKikimr = new LocalKikimr();
    @Rule
    public TestName name = new TestName();

    private YdbHelper ydb;
    private YdbQuickLinksDao quickLinksDao;

    @Before
    public void setUp() {
        ydb = new YdbHelper(localKikimr, getClass().getSimpleName() + "_" + name.getMethodName());
        quickLinksDao = new YdbQuickLinksDao(ydb.getTableClient(), ydb.resolvePath("QuickLinks"), createObjectMapper());
        join(quickLinksDao.createSchemaForTests());
    }

    @After
    public void tearDown() {
        join(quickLinksDao.dropSchemaForTests());
        ydb.close();
    }

    @Override
    public QuickLinksDao getDao() {
        return quickLinksDao;
    }
}
