package ru.yandex.solomon.config;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.config.protobuf.DataSize;
import ru.yandex.solomon.config.protobuf.DataUnit;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class DataSizeConverter {
    public DataSizeConverter() {
    }

    public static long convert(long value, DataUnit from, DataUnit to) {
        int length = from.getNumber() - to.getNumber();
        if (length == 0) {
            return value;
        }

        if (length > 0) {
            return Math.round(value * Math.pow(1024, length));
        } else {
            return Math.round(value / Math.pow(1024, Math.abs(length)));
        }
    }

    public static long toBytes(DataSize dataSize) {
        return convert(dataSize.getValue(), dataSize.getUnit(), DataUnit.BYTES);
    }

    public static int toBytesInt(DataSize dataSize) {
        return Math.toIntExact(toBytes(dataSize));
    }
}
