package ru.yandex.solomon.config;

import java.io.IOException;
import java.io.UncheckedIOException;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author Sergey Polovko
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public final class IamKeyJson {

    private final String id;
    private final String accountId;
    private final String privateKey;

    @JsonCreator
    IamKeyJson(
            @JsonProperty("id") String id,
            @JsonProperty("service_account_id") String accountId,
            @JsonProperty("private_key") String privateKey)
    {
        this.id = id;
        this.accountId = accountId;
        this.privateKey = privateKey;
    }

    public static IamKeyJson parseFromJson(String json) {
        try {
            var mapper = new ObjectMapper();
            return mapper.readValue(json, IamKeyJson.class);
        } catch (IOException e) {
            throw new UncheckedIOException("cannot parse IAM key from " + json, e);
        }
    }

    public String getId() {
        return id;
    }

    public String getAccountId() {
        return accountId;
    }

    public String getPrivateKey() {
        return privateKey;
    }
}
