package ru.yandex.solomon.config;

import java.time.Duration;
import java.util.concurrent.TimeUnit;

import ru.yandex.solomon.config.protobuf.Time;

/**
 * @author Vladimir Gordiychuk
 */
public final class TimeConverter {
    private TimeConverter() {
    }

    public static Duration protoToDuration(Time time) {
        return protoToDuration(time, Duration.ZERO);
    }

    public static Duration protoToDuration(Time time, Duration def) {
        if (time == Time.getDefaultInstance()) {
            return def;
        }

        TimeUnit unit = TimeUnitConverter.protoToUnit(time.getUnit());
        return Duration.ofMillis(unit.toMillis(time.getValue()));
    }
}
