package ru.yandex.solomon.config;

import java.util.concurrent.TimeUnit;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.config.protobuf.Time;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class TimeUnitConverter {
    private TimeUnitConverter() {
    }

    public static TimeUnit protoToUnit(ru.yandex.solomon.config.protobuf.TimeUnit proto) {
        int num = proto.getNumber();
        TimeUnit[] units = TimeUnit.values();
        if (num < 0 || num >= units.length) {
            throw new UnsupportedOperationException("Unsupported time unit: " + proto);
        }

        return units[num];
    }

    public static long millis(Time time, long defaultValueMs) {
        var res = millis(time);
        return res == 0 ? defaultValueMs : res;
    }

    public static long millis(Time time) {
        if (time.getValue() == 0) {
            return 0;
        }

        var unit = protoToUnit(time.getUnit());
        if (unit == null) {
            return 0;
        }

        return unit.toMillis(time.getValue());
    }

    public static ru.yandex.solomon.config.protobuf.TimeUnit unitToProto(TimeUnit unit) {
        return ru.yandex.solomon.config.protobuf.TimeUnit.forNumber(unit.ordinal());
    }
}
