package ru.yandex.solomon.config.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;


/**
 * This executor will reject directly submitted tasks to prevent usage of this thread pool
 * in wrong way.
 *
 * @author Sergey Polovko
 */
class OnlyScheduledExecutor extends ScheduledThreadPoolExecutor {

    OnlyScheduledExecutor(ThreadFactory threadFactory) {
        super(1, threadFactory);
    }

    @Override
    public void execute(Runnable command) {
        reject(command);
    }

    @Override
    public Future<?> submit(Runnable task) {
        reject(task);
        // not reachable
        return null;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        reject(task);
        // not reachable
        return null;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        reject(() -> {
            try {
                task.call();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        // not reachable
        return null;
    }

    private void reject(Runnable command) {
        getRejectedExecutionHandler().rejectedExecution(command, this);
    }
}
