package ru.yandex.solomon.config.thread;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import com.google.common.collect.ImmutableSet;
import io.netty.channel.EventLoopGroup;
import org.springframework.stereotype.Component;

import ru.yandex.solomon.util.NettyUtils;

/**
 * @author alexlovkov
 */
@Component
public class StubThreadPoolProvider implements ThreadPoolProvider {

    private static final String THREAD_POOL_NAME = "stub-thread-pool";

    private final EventLoopGroup eventLoopGroup;

    public StubThreadPoolProvider(int nThreads) {
        eventLoopGroup = NettyUtils.createEventLoopGroup(THREAD_POOL_NAME, nThreads);
    }

    public StubThreadPoolProvider() {
        this(4);
    }

    @Override
    public Set<String> getKnownNames() {
        return ImmutableSet.of(
            THREAD_POOL_NAME,
            SystemThreadPools.IO.getName(),
            SystemThreadPools.SCHEDULER.getName());
    }

    @Override
    public ExecutorService getExecutorService(String threadPoolName, String configName) {
        return eventLoopGroup;
    }

    @Override
    public EventLoopGroup getIOExecutor() {
        return eventLoopGroup;
    }

    @Override
    public ScheduledExecutorService getSchedulerExecutorService() {
        return eventLoopGroup;
    }

    @Override
    public void close() {
        eventLoopGroup.shutdownGracefully();
    }
}
