package ru.yandex.solomon.config.thread;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

import io.netty.channel.EventLoopGroup;

/**
 * @author alexlovkov
 */
public interface ThreadPoolProvider extends AutoCloseable {

    enum SystemThreadPools {
        IO("Io"),
        SCHEDULER("Scheduler");

        private final String name;

        SystemThreadPools(String name) {
            this.name = name;
        }

        public String getName() {
            return name;
        }
    }


    Set<String> getKnownNames();

    // TODO: remove ugly configName parameter, using MessageProxy @alexlovkov
    ExecutorService getExecutorService(String threadPoolName, String configName);

    EventLoopGroup getIOExecutor();

    ScheduledExecutorService getSchedulerExecutorService();

    @Override
    void close();
}
