package ru.yandex.solomon.config;

import java.util.Arrays;
import java.util.List;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.solomon.config.protobuf.TThreadPoolConfig;
import ru.yandex.solomon.config.protobuf.TThreadPoolsConfig;
import ru.yandex.solomon.config.thread.LazyThreadPoolProvider;
import ru.yandex.solomon.config.thread.StubThreadPoolProvider;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;

/**
 * @author alexlovkov
 */
@RunWith(Parameterized.class)
public class ThreadPoolProviderTest {

    @Parameterized.Parameter(value = 0)
    public String name;

    @Parameterized.Parameter(value = 1)
    public static ThreadPoolProvider threadPoolProvider;

    @Parameterized.Parameters(name = "{0}")
    public static List<Object> classes() {
        return Arrays.asList(new Object[][] {
                { LazyThreadPoolProvider.class.getSimpleName(), createLazyThreadPoolProvider() },
                { StubThreadPoolProvider.class.getSimpleName(), new StubThreadPoolProvider() }
        });
    }

    private static ThreadPoolProvider createLazyThreadPoolProvider() {
        TThreadPoolsConfig.Builder builder = TThreadPoolsConfig.newBuilder();
        builder.addThreadPools(createPoolBuilder("Io", 4));
        builder.addThreadPools(createPoolBuilder("Scheduler", 4));
        builder.addThreadPools(createPoolBuilder("Qwe1", 1));
        builder.addThreadPools(createPoolBuilder("Qwe2", 2));
        builder.addThreadPools(createPoolBuilder("Qwe4", 4));
        TThreadPoolsConfig config = builder.build();
        return new LazyThreadPoolProvider(config);
    }

    private static TThreadPoolConfig.Builder createPoolBuilder(String name, int threads) {
        TThreadPoolConfig.Builder configBuilder = TThreadPoolConfig.newBuilder();
        configBuilder.setName(name);
        configBuilder.setThreads(threads);
        return configBuilder;
    }

    @Test
    public void testReturnTheSameThreadPool() {
        Assert.assertSame(threadPoolProvider.getIOExecutor(), threadPoolProvider.getIOExecutor());
        Assert.assertSame(threadPoolProvider.getSchedulerExecutorService(), threadPoolProvider.getSchedulerExecutorService());
        Assert.assertSame(threadPoolProvider.getExecutorService("Qwe1", ""), threadPoolProvider.getExecutorService("Qwe1", ""));
        Assert.assertSame(threadPoolProvider.getExecutorService("Qwe2", ""), threadPoolProvider.getExecutorService("Qwe2", ""));
        Assert.assertSame(threadPoolProvider.getExecutorService("Qwe4", ""), threadPoolProvider.getExecutorService("Qwe4", ""));
    }

    @AfterClass
    public static void closeResources() {
        threadPoolProvider.close();
    }
}
