SET (_netty_version 4.1.63.Final)
DEPENDENCY_MANAGEMENT(
    contrib/java/io/netty/netty-all/${_netty_version}
    contrib/java/io/netty/netty-buffer/${_netty_version}
    contrib/java/io/netty/netty-common/${_netty_version}
    contrib/java/io/netty/netty-codec-dns/${_netty_version}
    contrib/java/io/netty/netty-codec-http/${_netty_version}
    contrib/java/io/netty/netty-codec-http2/${_netty_version}
    contrib/java/io/netty/netty-codec-socks/${_netty_version}
    contrib/java/io/netty/netty-handler/${_netty_version}
    contrib/java/io/netty/netty-handler-proxy/${_netty_version}
    contrib/java/io/netty/netty-resolver-dns/${_netty_version}
    contrib/java/io/netty/netty-transport-native-epoll-linux-x86_64/${_netty_version}
    contrib/java/io/netty/netty-transport-native-kqueue-osx-x86_64/${_netty_version}
)

SET (_spring_version 5.3.18)
DEPENDENCY_MANAGEMENT(
    contrib/java/org/springframework/spring-aop/${_spring_version}
    contrib/java/org/springframework/spring-beans/${_spring_version}
    contrib/java/org/springframework/spring-context/${_spring_version}
    contrib/java/org/springframework/spring-core/${_spring_version}
    contrib/java/org/springframework/spring-expression/${_spring_version}
    contrib/java/org/springframework/spring-jdbc/${_spring_version}
    contrib/java/org/springframework/spring-test/${_spring_version}
    contrib/java/org/springframework/spring-tx/${_spring_version}
    contrib/java/org/springframework/spring-webflux/${_spring_version}
    contrib/java/org/springframework/spring-web/${_spring_version}
)

SET (_slf4j_version 1.8.0-alpha2)
DEPENDENCY_MANAGEMENT(
    contrib/java/org/slf4j/jul-to-slf4j/${_slf4j_version}
    contrib/java/org/slf4j/slf4j-api/${_slf4j_version}
    contrib/java/org/slf4j/slf4j-simple/${_slf4j_version}
)

SET (_log4j_version 2.17.1)
DEPENDENCY_MANAGEMENT(
    contrib/java/org/apache/logging/log4j/log4j-api/${_log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-core/${_log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-slf4j18-impl/${_log4j_version}
)

SET (_jmh_version 1.19)
DEPENDENCY_MANAGEMENT(
    contrib/java/org/openjdk/jmh/jmh-core/${_jmh_version}
    contrib/java/org/openjdk/jmh/jmh-generator-annprocess/${_jmh_version}
)

SET (_grpc_version 1.43.2)
DEPENDENCY_MANAGEMENT(
    contrib/java/io/grpc/grpc-core/${_grpc_version}
    contrib/java/io/grpc/grpc-netty/${_grpc_version}
    contrib/java/io/grpc/grpc-protobuf/${_grpc_version}
    contrib/java/io/grpc/grpc-services/${_grpc_version}
    contrib/java/io/grpc/grpc-stub/${_grpc_version}
    contrib/java/io/grpc/grpc-testing/${_grpc_version}
)

SET (_swagger_version 3.0.0)
DEPENDENCY_MANAGEMENT(
    contrib/java/io/springfox/springfox-swagger2/${_swagger_version}
    contrib/java/io/springfox/springfox-swagger-ui/${_swagger_version}
)

SET (_jackson_version 2.9.10)
DEPENDENCY_MANAGEMENT(
    contrib/java/com/fasterxml/jackson/core/jackson-annotations/${_jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-core/${_jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-databind/${_jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-xml/${_jackson_version}
)

DEPENDENCY_MANAGEMENT(contrib/java/com/google/guava/guava/26.0-jre)
DEPENDENCY_MANAGEMENT(contrib/java/org/apache/commons/commons-lang3/3.5)
DEPENDENCY_MANAGEMENT(contrib/java/org/asynchttpclient/async-http-client/2.10.4)
DEPENDENCY_MANAGEMENT(contrib/java/io/jaegertracing/jaeger-client/1.3.2)

SET (_opentracing_version 0.33.0)
DEPENDENCY_MANAGEMENT(
    contrib/java/io/opentracing/opentracing-api/${_opentracing_version}
    contrib/java/io/opentracing/opentracing-util/${_opentracing_version}
)

DEPENDENCY_MANAGEMENT(contrib/java/javax/annotation/javax.annotation-api/1.3.2)

DEPENDENCY_MANAGEMENT(contrib/java/it/unimi/dsi/fastutil/8.5.6)

EXCLUDE(
    # exclude incorrect logging libraries from classpath
    contrib/java/ch/qos/logback/logback-classic
    contrib/java/ch/qos/logback/logback-core
    contrib/java/log4j/log4j
    contrib/java/org/slf4j/log4j-over-slf4j/1.7.16
    contrib/java/org/apache/logging/log4j/log4j-api/2.5
    contrib/java/org/apache/logging/log4j/log4j-core/2.5
    contrib/java/org/productivity/syslog4j
    contrib/java/org/hibernate/hibernate-validator
    contrib/java/commons-logging/commons-logging
    contrib/java/javax/servlet/servlet-api

    contrib/java/com/fasterxml/jackson/core/jackson-databind/2.6.5
    iceberg/misc/testlib
    iceberg/misc-bender/testlib
    iceberg/misc-xml
    contrib/java/io/grpc/grpc-context/1.14.0

    # old version of guava
    contrib/java/com/google/guava/guava/18.0
    contrib/java/com/google/guava/guava/19.0

    # to avoid jar hell via grpc, see https://st.yandex-team.ru/SOLOMON-8694
    contrib/java/com/google/protobuf/protobuf-javalite
)

# list with service specific exclusions
SET (service_excludes
    contrib/java/javax/validation
    contrib/java/org/hibernate/hibernate-validator
    contrib/java/org/springframework/spring-test
    contrib/java/org/springframework/spring-jdbc
    contrib/java/javax/annotation/javax.annotation-api
    contrib/java/io/springfox/springfox-spring-webmvc

    # we use netty-all in all services
    contrib/java/io/netty/netty-common
    contrib/java/io/netty/netty-buffer
    contrib/java/io/netty/netty-codec
    contrib/java/io/netty/netty-codec-dns
    contrib/java/io/netty/netty-codec-http
    contrib/java/io/netty/netty-codec-http2
    contrib/java/io/netty/netty-codec-socks
    contrib/java/io/netty/netty-handler
    contrib/java/io/netty/netty-handler-proxy
    contrib/java/io/netty/netty-resolver
    contrib/java/io/netty/netty-resolver-dns
    contrib/java/io/netty/netty-transport
    contrib/java/io/netty/netty-transport-native-epoll-linux-x86_64
 )
