package ru.yandex.solomon.coremon.client;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

import com.google.common.collect.ImmutableList;

import ru.yandex.monitoring.coremon.DeleteMetricsRequest;
import ru.yandex.monitoring.coremon.DeleteMetricsResponse;
import ru.yandex.monitoring.coremon.TDataProcessResponse;
import ru.yandex.monitoring.coremon.TPulledDataRequest;
import ru.yandex.monitoring.coremon.TPushedDataRequest;
import ru.yandex.monitoring.coremon.TRemoveShardRequest;
import ru.yandex.monitoring.coremon.TRemoveShardResponse;
import ru.yandex.solomon.scheduler.proto.GetTaskRequest;
import ru.yandex.solomon.scheduler.proto.Task;


/**
 * @author Sergey Polovko
 */
public interface CoremonClient {

    CompletableFuture<TDataProcessResponse> processPulledData(String host, TPulledDataRequest request);

    CompletableFuture<TDataProcessResponse> processPushedData(String host, TPushedDataRequest request);

    CompletableFuture<List<String>> initShard(String projectId, String shardId, int numId);

    CompletableFuture<ShardInfo> createShard(
            String projectId,
            String clusterName,
            String serviceName,
            String createdBy);

    CompletableFuture<Void> removeShard(String projectId, String shardId, int numId);

    CompletableFuture<TRemoveShardResponse> removeShard(String clusterId, TRemoveShardRequest request);

    CompletableFuture<Void> reloadShard(String host, String projectId, String shardId);

    CompletableFuture<DeleteMetricsResponse> deleteMetrics(String clusterId, DeleteMetricsRequest request);

    CompletableFuture<Task> getTask(String clusterId, GetTaskRequest request);

    ImmutableList<String> shardHosts(int shardId);

    Set<String> clusterIds();
}
